/*
 * Decompiled with CFR 0.152.
 */
package fuzs.spikyspikes.world.level.block;

import fuzs.spikyspikes.SpikySpikes;
import fuzs.spikyspikes.config.ServerConfig;
import java.util.function.DoubleSupplier;
import net.minecraft.ChatFormatting;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public enum SpikeMaterial {
    WOOD(0, () -> ((ServerConfig)SpikySpikes.CONFIG.get(ServerConfig.class)).woodenSpikeDamage),
    STONE(1, () -> ((ServerConfig)SpikySpikes.CONFIG.get(ServerConfig.class)).stoneSpikeDamage),
    IRON(2, () -> ((ServerConfig)SpikySpikes.CONFIG.get(ServerConfig.class)).ironSpikeDamage),
    GOLD(3, () -> ((ServerConfig)SpikySpikes.CONFIG.get(ServerConfig.class)).goldenSpikeDamage),
    DIAMOND(4, () -> ((ServerConfig)SpikySpikes.CONFIG.get(ServerConfig.class)).diamondSpikeDamage),
    NETHERITE(5, () -> ((ServerConfig)SpikySpikes.CONFIG.get(ServerConfig.class)).netheriteSpikeDamage);

    private final int materialTier;
    private final DoubleSupplier damageAmount;

    private SpikeMaterial(int materialTier, DoubleSupplier damageAmount) {
        this.materialTier = materialTier;
        this.damageAmount = damageAmount;
    }

    public float damageAmount() {
        return (float)this.damageAmount.getAsDouble();
    }

    public ChatFormatting tooltipStyle() {
        if (this.isAtLeast(DIAMOND)) {
            return ChatFormatting.GREEN;
        }
        if (this.isAtLeast(IRON)) {
            return ChatFormatting.AQUA;
        }
        return ChatFormatting.RED;
    }

    public Item swordItem() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case WOOD -> Items.f_42420_;
            case STONE -> Items.f_42425_;
            case IRON -> Items.f_42383_;
            case GOLD -> Items.f_42430_;
            case DIAMOND -> Items.f_42388_;
            case NETHERITE -> Items.f_42393_;
        };
    }

    public boolean dealsFinalBlow() {
        return this.isAtLeast(STONE);
    }

    public boolean dropsLoot() {
        return this != STONE && this != GOLD;
    }

    public boolean dropsJustExperience() {
        return this == GOLD;
    }

    public boolean dropsPlayerLoot() {
        return this.isAtLeast(DIAMOND);
    }

    public boolean acceptsEnchantments() {
        return this.isAtLeast(DIAMOND);
    }

    public boolean hurtsPlayers() {
        return this != NETHERITE;
    }

    private boolean isAtLeast(SpikeMaterial material) {
        return this.materialTier >= material.materialTier;
    }
}

